// GFC.cpp : Defines the entry point for the console application.
//

#include "Move.h"
#include "stdafx.h"
#include "Engine.h"

#include <iostream>
#include <string>
using namespace std;

int main(int argc, char* argv[])
{
	Engine* engine = new Engine();

	//engine->Test();

	//return 0;
	string command;
	char userMove [4];

	char columns[8] = {'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'};

	while (true)
	{
		cin >> command;

		if (command == "go")
		{
			int moveCount = 1;
			int sideCount = 0;
			int movesPerLine = 0;

			Move move = engine->GetBestMove(3);
			engine->MakeMove(move);

			move.PrintMove();

			cout << endl;
			break;
		}
	}	
		
	cin >> userMove;
	
	while (true)
	{
		int fromColumnNumber;
		int fromRankNumber;
		int toColumnNumber;
		int toRankNumber;

		char fromColumn = userMove[0];
		char fromRank = userMove[1];
		char toColumn = userMove[2];
		char toRank = userMove[3];

		for (int i=0; i<8; i++)
		{
			if (fromColumn == columns[i])
			{
				fromColumnNumber = i;
				
			}
			if (toColumn == columns[i])
			{
				toColumnNumber = i;
			}
		}
		
		fromRankNumber = atoi(&fromRank)-1;
		toRankNumber = atoi(&toRank)-1;
	
		int from = fromRankNumber*8 + fromColumnNumber;
		int to = toRankNumber*8 + toColumnNumber;

		GeneratedMoves* moves = engine->GenerateAllSortedMoves();

		for (int i=0; i<moves->MovesCount; i++)
		{
			Move move = moves->AllLegalMoves[i];
			if (move.From == from && move.To == to)
			{
				engine->MakeMove(move);
				//move.PrintMove();
				//cout << endl;
			}
		}

		Move move = engine->GetBestMove(3);
		engine->MakeMove(move);

		move.PrintMove();

		cout << endl;

		cin >> userMove;
	}		
		
	

	return 0;
}




